<?php
/**
 * Enqueues child theme stylesheet, loading first the parent theme stylesheet.
 */
function rokka_custom_enqueue_child_theme_styles() {
    wp_enqueue_style('rokka-child-style', get_stylesheet_uri(), array('rokka-app'));
}

add_action('wp_enqueue_scripts', 'rokka_custom_enqueue_child_theme_styles', 11);
add_filter('acf/settings/load_json', 'rokka_acf_settings');

function rokka_acf_settings($paths) {
    $paths = array(get_template_directory() . '/acf-json');

    if(is_child_theme()){
        $paths = array(
            get_stylesheet_directory() . '/acf-json',
            get_template_directory() . '/acf-json'
        );

    }
    return $paths;
};