<?php
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">

	<?php
	if ( have_comments() ) :
		?>
		<h2 class="comments-title h4">
			<?php
			$rokka_comment_count = get_comments_number();
			if ( '1' === $rokka_comment_count ) {
				printf(
					esc_html__( 'One thought on &ldquo;%1$s&rdquo;', 'rokka' ),
					'<span>' . get_the_title() . '</span>'
				);
			} else {
				printf(
					esc_html( _nx( '%1$s thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', $rokka_comment_count, 'comments title', 'rokka' ) ),
					number_format_i18n( $rokka_comment_count ),
					'<span>' . get_the_title() . '</span>'
				);
			}
			?>
		</h2>

		<?php the_comments_navigation(); ?>

		<ol class="comment-list">
			<?php
			wp_list_comments( array(
				'max_depth'  => 3,
				'walker'     => new Rokka_Walker_Comment(),
				'style'      => 'ol',
				'short_ping' => true,
			) );
			?>
		</ol>

		<?php
		the_comments_navigation();
		if ( ! comments_open() ) :
			?>
			<h4 class="no-comments"><?php esc_html_e( 'Comments are closed.', 'rokka' ); ?></h4>
			<?php
		endif;
	endif;
	comment_form();
	?>

</div>
