<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package rokka
 */

?>

<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
	<meta name="theme-color" content="#f1e2b1" />
	<!-- Windows Phone -->
	<meta name="msapplication-navbutton-color" content="#f1e2b1">
	<!-- iOS Safari -->
	<meta name="apple-mobile-web-app-capable" content="yes">
	<meta name="apple-mobile-web-app-status-bar-style" content="#f1e2b1">
	
</head>

<body <?php body_class(); ?>>
	<div class="rokka-loader">

	</div>
	<?php
	get_template_part('template-parts/navigation', ''); 
	?>
	<div class="page-wrapper">
		<div class="nav-helper"></div>
