<?php
add_action( 'customize_register', 'rokka_register_theme_customizer' );
/*
 * Register Our Customizer Stuff Here
 */
function rokka_register_theme_customizer( $wp_customize ) {
	// Create custom panel.
	$wp_customize->add_panel( 'rokka_text_blocks', array(
		'priority'       => 500,
		'theme_supports' => '',
		'title'          => __( 'Footer', 'rokka' ),
		'description'    => __( 'Set editable text for certain content.', 'rokka' ),
	) );
	// Add Footer Text
	// Add section.
	$wp_customize->add_section( 'custom_footer_text' , array(
		'title'    => __('Change Footer Text','rokka'),
		'panel'    => 'rokka_text_blocks',
		'priority' => 10
	) );
	// Add setting
	$wp_customize->add_setting( 'rokka_footer_text_block', array(
		 'default'           => '',
		 'sanitize_callback' => 'rokka_sanitize_text'
	) );
	// Add control
	$wp_customize->add_control( new WP_Customize_Control(
	    $wp_customize,
		'custom_footer_text',
		    array(
		        'label'    => __( 'Footer Text', 'rokka' ),
		        'section'  => 'custom_footer_text',
		        'settings' => 'rokka_footer_text_block',
		        'type'     => 'text'
		    )
	    )
	);
 	// Sanitize text
	function rokka_sanitize_text( $text ) {
	    return sanitize_text_field( $text );
	}
}