<?php

if ( ! function_exists( 'rokka_enqueue_scripts' ) ) :
	function rokka_enqueue_scripts() {
		wp_enqueue_style( 'rokka-style', get_stylesheet_uri() );
		wp_enqueue_style( 'rokka-app', get_theme_file_uri('/assets/css/app.css'), array(), '1.0.0', 'all' );

		wp_enqueue_script( 'imagesloaded' );
		wp_enqueue_script( 'masonry' );
		wp_enqueue_script( 'TweenMax', get_theme_file_uri( '/assets/js/libs/TweenMax.min.js' ), array(), '2.0.2', true );
		wp_enqueue_script( 'ScrollToPlugin', get_theme_file_uri( '/assets/js/libs/ScrollToPlugin.min.js' ), array( 'jquery' ), '1.9.0', true );
		wp_enqueue_script( 'sticky-kit', get_theme_file_uri( '/assets/js/libs/sticky-kit.min.js' ), array(), '1.1.3', true );
		wp_enqueue_script( 'swiper', get_theme_file_uri( '/assets/js/libs/swiper.min.js'), array(), '4.3.3', true );
		wp_enqueue_script( 'magnific-popup', get_theme_file_uri( '/assets/js/libs/jquery.magnific-popup.min.js'), array(), '4.3.3', true );
		wp_enqueue_script( 'jarallax', get_theme_file_uri( '/assets/js/libs/jarallax.min.js' ), array( 'jquery' ), '1.10.4', true );
		wp_enqueue_script( 'jarallax-video', get_theme_file_uri( '/assets/js/libs/jarallax-video.min.js' ), array( 'jquery' ), '1.0.1', true );
		wp_enqueue_script( 'vegas', get_theme_file_uri( '/assets/js/libs/vegas.min.js' ), array( 'jquery' ), '2.4.4', true );
		wp_enqueue_script( 'count-up', get_theme_file_uri( '/assets/js/libs/countUp.js' ), array( 'jquery' ), '1.0.0', true );
		wp_enqueue_script( 'YTPlayer', get_theme_file_uri( '/assets/js/libs/jquery.mb.YTPlayer.min.js' ), array( 'jquery' ), '3.2.8', true );
		wp_enqueue_script( 'rokka-app', get_theme_file_uri( '/assets/js/app.js' ), array( 'jquery' ), '1.0.0', true );

		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
		if(function_exists('rokka_output_styles')) {
			add_action( 'wp_enqueue_scripts', 'rokka_output_styles', 21);
		}

		$jsVars = array(
			'api_nonce' => wp_create_nonce( 'wp_rest' ),
			'api_url'   => site_url('/wp-json/wp/v2/'),
		);

		wp_localize_script( 'rokka-app', 'rest_object', $jsVars);

		if(!function_exists('get_field') || !get_option('options_rokka_bg')) {
			wp_enqueue_style( 'rokka-basic', get_template_directory_uri() . '/assets/css/basic.css', array(), '1.0.0', 'all' );
		}

		if(function_exists('get_field')) {
			$footer = '';
			if(get_field('rokka_page_select_footer')) {
				$footer = get_field('rokka_page_select_footer');
			} elseif(get_field('rokka_select_footer', 'option')) {
				$footer = get_field('rokka_select_footer', 'option');
			}

			if($footer) {
				wp_add_inline_style('rokka-app', get_post_meta($footer->ID, '_wpb_shortcodes_custom_css', true));
			}
		}

		if(!function_exists('get_field') || !get_option('rokka_typography')) {
			wp_enqueue_style('rokka-basic-typography', '//fonts.googleapis.com/css?family=Montserrat:400%2C600%7CCormorant+Garamond:600%2C600italic%7CMontserrat:400%7CMontserrat:500' );
			$basicTypography = "body{font-family:'Montserrat',Arial, Helvetica, sans-serif;font-weight:400;font-style:normal;}h1,h2,h3,h4,h5,h6,.h1,.h2,.h3,.h4,.h5,.h6,.wpb-js-composer .vc_tta-tabs .vc_tta-title-text, #comments .comment-list .comment-header .comment-author-link, .hb_single_room .room-sidebar-inner > div > .room-price, .widget_categories ul li, .widget_archive ul li, .widget_pages ul li, .widget_nav_menu ul li, #wp-calendar caption, .widget_rokka_recent_comments .comment-author-link, .widget_rss .rsswidget, .widget_recent_entries a, .rokka-gallery.rokka-gallery-element figcaption{font-family:'Cormorant Garamond',Arial, Helvetica, sans-serif;font-weight:600;font-style:normal;}.single-product-categories, .reset_variations, span.onsale, .button, .products-sidebar-left #sidebar, .product-sidebar-left #sidebar, .cart-box .cart-close, .cart-box .rokka-empty-cart .btn-text, .blog-wrapper .blog-inner .more-link, .blog-grid-wrapper .blog-inner .entry-meta-categories, #commentform input[type=submit], .wp-caption-text, figcaption, .post-password-form input[type=submit], .page-links, .pagination .nav-links, .button, .btn, .mailchimp-form-1 .mailchimp-form-1-main input[type=submit], .widget, .subheading, .search-results nav .nav-links, .wpcf7 input[type=submit], .site-header-logo, .nav-overlay .main-logo h1, .rokka-counter .icon-value p.counter{font-family:'Montserrat',Arial, Helvetica, sans-serif;font-weight:400;font-style:normal;}.nav-container .subnav, .nav-container .nav-scroller .nav{font-family:'Montserrat',Arial, Helvetica, sans-serif;font-weight:500;font-style:normal;font-size:12px;}";
			wp_add_inline_style( 'rokka-app', $basicTypography );
		}


	}
	add_action( 'wp_enqueue_scripts', 'rokka_enqueue_scripts' );
endif;