<?php

if ( ! function_exists( 'rokka_setup' ) ) :
	function rokka_setup() {
		load_theme_textdomain( 'rokka', get_template_directory() . '/languages' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		add_image_size( 'rokka-square', 500, 500, true );
		add_image_size( 'rokka-slider', 1920, 700, true );
		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1' => esc_html__( 'Primary', 'rokka' ),
		) );
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'gallery',
			'caption',
		) );
	}
endif;
add_action( 'after_setup_theme', 'rokka_setup' );

function rokka_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'rokka_content_width', 640 );
}
add_action( 'after_setup_theme', 'rokka_content_width', 0 );

function rokka_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Blog sidebar', 'rokka' ),
		'id'            => 'sidebar-blog',
		'description'   => esc_html__( 'Add widgets here.', 'rokka' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title"><strong>',
		'after_title'   => '</strong></h5>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Post sidebar', 'rokka' ),
		'id'            => 'sidebar-post',
		'description'   => esc_html__( 'Add widgets here.', 'rokka' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title"><strong>',
		'after_title'   => '</strong></h5>',
	) );
	if(class_exists('WP_Hotel_Booking')) {
		register_sidebar( array(
			'name'          => esc_html__( 'Room sidebar', 'rokka' ),
			'id'            => 'sidebar-room',
			'description'   => esc_html__( 'Add widgets here.', 'rokka' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h5 class="widget-title heading heading-decorator-1"><strong>',
			'after_title'   => '</strong></h5>',
		) );
	}
	
}
add_action( 'widgets_init', 'rokka_widgets_init' );


function rokka_register_required_plugins() {
	$plugins = array(
		array(
			'name'               => esc_html__('Rokka Theme Plugin', 'rokka'),
			'slug'               => 'rokka-theme-plugin',
			'source'             =>  get_template_directory() . '/inc/plugins/rokka-theme-plugin.zip',
			'required'           => true,
			'version'            => '1.0.0',
			'force_activation'   => false,
			'force_deactivation' => false,
			'external_url'       => '',
			'is_callable'        => '',
		),

		array(
			'name'               => esc_html__('WPBakery Page Builder', 'rokka'),
			'slug'               => 'js_composer',
			'source'             => get_template_directory() . '/inc/plugins/js_composer.zip',
			'required'           => false,
			'version'            => '5.6',
			'force_activation'   => false,
			'force_deactivation' => false,
			'external_url'       => '',
			'is_callable'        => '',
		),
		array(
			'name'               => esc_html__('Slider Revolution', 'rokka'),
			'slug'               => 'revslider',
			'source'             => get_template_directory() . '/inc/plugins/revslider.zip',
			'required'           => false,
			'version'            => '5.4.8.2',
			'force_activation'   => false,
			'force_deactivation' => false,
			'external_url'       => '',
			'is_callable'        => '',
		),
	);

	$config = array(
		'id'           => 'rokka',
		'default_path' => '',
		'menu'         => 'tgmpa-install-plugins',
		'parent_slug'  => 'themes.php',
		'capability'   => 'edit_theme_options',
		'has_notices'  => true,
		'dismissable'  => true,
		'dismiss_msg'  => '',
		'is_automatic' => false,
		'message'      => '',
	);

	tgmpa( $plugins, $config );

}

add_action('tgmpa_register', 'rokka_register_required_plugins');


add_action( 'vc_before_init', 'rokka_vc_before_init' );
function rokka_vc_before_init() {
	vc_set_as_theme(true);
}

add_action( 'vc_after_init', 'rokka_vc_after_init_actions' );
function rokka_vc_after_init_actions() {
	if( function_exists('vc_set_default_editor_post_types') ){ 
		$list = array(
			'page',
			'rokka_footer',
			'post',
		);
		vc_set_default_editor_post_types( $list );
	}
	 
	if( function_exists('vc_disable_frontend') ){
		vc_disable_frontend();
	}   
}

function rokka_check_sidebar_param() {
	if(isset($_GET['sidebar'])) {
		$sidebarParam = $_GET['sidebar'];
		if('no' == $sidebarParam) {
			return false;
		}
	}
	return true;
}

function rokka_mobile_languages(){
	$output = '';
	if(function_exists('icl_get_languages')) {
	    $languages = icl_get_languages('skip_missing=0&orderby=code');
	    if(!empty($languages)){
	        $output .= '<div class="overlay-nav-language-switcher"><ul>';
	        foreach($languages as $l){
	            $output .= '<li>';
	            if(!$l['active']) $output .= '<a href="'.$l['url'].'">';
	            if($l['active']) $output .= '<span class="rokka-mobile-current-language">';
	            $output .= icl_disp_language($l['native_name']);
	            if(!$l['active']) $output .= '</a>';
	            if($l['active']) $output .= '</span>';
	            $output .= '</li>';
	        }
	        $output .= '</ul></div>';
	    }
	}
	$output .= apply_filters('rokka_mobile_languages', '');
	echo rokka_get_output($output);
}

function rokka_navbar_languages(){
	$output = '';
	if(function_exists('icl_get_languages')) {
	    $languages = icl_get_languages('skip_missing=0&orderby=code');
	    if(!empty($languages)){
	    	$home_url = apply_filters( 'wpml_home_url', home_url() );
	        $output .= '<div class="navbar-language-switcher"><ul class="navbar-first-level">';
			$output .= '<li class="menu-item menu-item-type-post_type menu-item-object-page menu-item-has-children nav-item has-children"><a href="'.esc_url($home_url).'">'.strtoupper(ICL_LANGUAGE_CODE).' <i class="ml-1 fa fa-angle-down"></i></a><ul class="sub-menu">';
	        foreach($languages as $l){
	            if(!$l['active']) {
		            $output .= '<li>';
		            $output .= '<a href="'.$l['url'].'">';
		            $output .= icl_disp_language($l['native_name']);
		            $output .= '</a>';
		            $output .= '</li>';
	            }
	        }
	        $output .= '</ul></li>';
	        $output .= '</ul></div>';
		}
    }
    $output .= apply_filters('rokka_navbar_languages', '');
    echo rokka_get_output($output);
}
