<?php
/*
Template Name: Blog grid
*/
get_header(); 

if ( get_query_var('paged') ) { $paged = get_query_var('paged'); }
elseif ( get_query_var('page') ) { $paged = get_query_var('page'); }
else { $paged = 1; }

$perpage = get_option('posts_per_page');

$query_params = array(
	'post_type' => 'post',
	'paged' => $paged,
	'posts_per_page' => $perpage,
	'ignore_sticky_posts' => true

);

$sidebar = 'show';
$post_class = $col_size = '';
if(function_exists('get_field')) {
	if(get_field('rokka_blog_sidebar', 'option') == true) {
		$sidebar = 'show';
		$col_size = 'col-lg-8';
		$post_class .= 'post-with-sidebar large-with-sidebar sidebar-on rokka-2-col';
	} else { 
		$sidebar = 'hide';
		$post_class .= 'post-without-sidebar rokka-3-col';
	}
} else {
	if(is_active_sidebar('sidebar-blog')) {
		$sidebar = 'show';
		$col_size = 'col-lg-8';
		$post_class .= 'post-with-sidebar large-with-sidebar sidebar-on rokka-2-col';
	} else {
		$sidebar = 'hide';
		$post_class .= 'post-without-sidebar rokka-3-col';		
	}
}

$wp_query = new WP_Query( $query_params );



?>
	<div class="container">
		<div class="row">
			<div class="col-12 <?php echo esc_attr($col_size); ?>">
				<div class="blog blog-inner blog-grid show-gutter <?php echo esc_attr( $post_class ); ?> mt-5">
					<div class="blog-grid-wrapper">
					<?php
					if ( $wp_query->have_posts() ) :
						while ( $wp_query->have_posts() ) :
							$wp_query->the_post();
							get_template_part( 'template-parts/content', 'grid' );
						endwhile;
						the_posts_pagination(array(
			    			'prev_text' => '<div class="previous-page arrow arrow-prev">&larr;</div>',
			    			'next_text' => '<div class="next-page arrow arrow-next">&rarr;</div>',
						)); 
						wp_reset_postdata();
					else :
						get_template_part( 'template-parts/content', 'none' );
					endif;
					?>
					</div>
				</div>
			</div>
			<?php if(is_active_sidebar('sidebar-blog') && $sidebar == 'show') : ?>
				<aside class="col-12 col-lg-4">
					<div class="blog-sidebar mt-5">
						<?php dynamic_sidebar('sidebar-blog'); ?>
					</div>
				</aside>
			<?php endif; ?>
		</div>
	</div>
<?php

get_footer();
