<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package rokka
 */

get_header();
$showHeader = true;

if(function_exists('get_field')) {
	if(get_field('rokka_page_titles', 'option') !== null ) {
		if(get_field('rokka_page_titles', 'option')) {
			$showHeader = true;
		} else {
			$showHeader = false;
		}
	}
} else {
	$showHeader = true;
}

?>
<?php if(has_post_thumbnail()) : ?>
<section>
	<div class="intro-slider intro-section">
		<div class="intro-slider-img swiper-container">
			<div class="intro-slider-inner swiper-wrapper">
				<div class="intro-slider-slide swiper-slide">
					<?php $thumbnail = get_the_post_thumbnail(null, 'full'); ?>
					<div class="intro-image"><?php echo rokka_get_output($thumbnail); ?></div>
				</div>
			</div>
		</div>
	</div>
</section>
<?php endif; ?>
	<div id="primary" class="container">
		<?php if(true === $showHeader) : ?>
			<header class="text-center">
				<h1 class="heading-decorator-1 my-5 pt-5"><?php the_title(); ?></h1>
			</header>
		<?php endif; ?>
		<?php if(!rokka_vc_active()) : ?>
		<div class="row justify-content-center">
			<div class="col-12 col-lg-9 ">
		<?php endif; ?>
				<?php
				while ( have_posts() ) :
					the_post();
					get_template_part( 'template-parts/content', 'page' );
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;
				endwhile;
				?>
		<?php if(!rokka_vc_active()) : ?>
			</div>
		</div>
		<?php endif; ?>
	</div>

<?php
get_sidebar();
get_footer();
