<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package rokka
 */

get_header();
$colOffset = '';
if ( !is_active_sidebar( 'sidebar-post' ) ) {
	$colOffset = 'offset-lg-2';
}
$sidebar = 'show';
$post_class = $img_class = '';
if(function_exists('get_field')) {
	if(get_field('rokka_single_post_sidebar', 'option') == true) {
		$sidebar = 'show';
		$post_class .= 'post-with-sidebar large-with-sidebar sidebar-on';
	} else { 
		$sidebar = 'hide';
		$post_class .= 'post-without-sidebar';
	}
} else {
	if(is_active_sidebar('sidebar-post')) {
		$sidebar = 'show';
		$post_class .= 'post-with-sidebar large-with-sidebar sidebar-on';
	} else {
		$sidebar = 'hide';
		$post_class .= 'post-without-sidebar';		
	}
}
if(!has_post_thumbnail()) {
	$post_class .= ' post-without-image';
}
?>

<section class="container">
	<div class="row">
		<section class="col-12 col-lg-8 <?php echo esc_attr($colOffset); ?>">
		<?php while ( have_posts() ) :
			the_post();

			if(has_post_thumbnail()) {
				echo '<div class="single-post-image-wrapper '.(( $sidebar != 'hide' ) ? 'stretch-left' : '').'">';
				$img_class = 'has_img';
				the_post_thumbnail(); 
				echo '</div>';
			} ?>
			<div class="single-post <?php echo esc_attr( $post_class ); ?> <?php echo esc_attr($img_class); ?>">
			<?php get_template_part( 'template-parts/content' ); ?>
			</div>

		<?php endwhile; ?>
		</section>
		<?php if(is_active_sidebar('sidebar-post') && $sidebar == 'show') : ?>
			<aside class="col-12 col-lg-4">
				<div class="blog-sidebar mt-5">
					<?php dynamic_sidebar('sidebar-post'); ?>
				</div>
			</aside>
		<?php endif; ?>
	</div>
</section>

<?php get_footer();
