<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package rokka
 */
$bg_img = $img_class = '';
?>
<?php if(has_post_thumbnail()) : ?>
	<?php $image_attributes = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'large' );
	$img_class = 'post-with-img text-light';
	$bg_img = 'background-image: url('.esc_url($image_attributes[0]).')'; ?>
<?php endif; ?>
<article id="post-<?php the_ID(); ?>" <?php post_class('post-grid '.$img_class.''); ?> style="<?php echo esc_attr($bg_img); ?>">		
	<div class="post-inner">
		<?php if ( 'post' === get_post_type() ) :
				?>
			<div class="entry-meta">
				<?php rokka_posted_on_grid(); ?>
			</div>
		<?php endif; ?>
		
		<header class="entry-header text-center">
			<?php
			if ( is_single() ) :
				the_title( '<h1 class="entry-title">', '</h1>' );
			else :
				the_title( '<h2 class="entry-title h4"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			endif;

			?>
			<div class="entry-meta-categories">
				<?php rokka_post_grid_category(); ?>
			</div>
		</header>
	</div>

	<?php if ( is_single() ) : ?>
	<footer class="entry-footer">
		<?php rokka_entry_footer(); ?>
	</footer>
	<?php endif; ?>
</article>
