<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package rokka
 */

?>

<article id="post-<?php the_ID(); ?>" class="<?php post_class('blog-post post-type-image'); ?>">
	<div class="post-img">
		<?php if(has_post_thumbnail()) : ?>
			<?php rokka_post_thumbnail('thumbnail'); ?>
		<?php else: ?>
			<?php if(get_the_title() != '') :?>
			<a href="<?php the_permalink(); ?>">
				<h3 class="h5"><?php echo substr(get_the_title(), 0, 1); ?></h3>
			</a>
			<?php endif; ?>
		<?php endif; ?>
	</div>
	<div class="post-content-wrapper">
		<header>
			<?php if(get_the_title() != '') :?>
				<h3 class="post-title h4">
					<a class="text-link" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
				</h3>
			<?php endif; ?>
		</header>
		<div class="post-meta-bar">
			<div class="post-date"><?php echo rokka_posted_on(); ?></div>
		</div>
	</div>
	<a class="btn-arrow" href="<?php the_permalink(); ?>"><div></div></a>
</article>