<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package rokka
 */
$shareData = array();
$shareData = array(
	'title'=>get_the_title(),
	'url'=>get_the_permalink()
);
$shareImage = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );
if(isset($shareImage[0])) {
	$shareImage = $shareImage[0];
	$shareData['image'] = $shareImage;
}

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('post-content'); ?>>
	<div class="post-content-wrapper">
		<div class="post-date">
			<span><?php echo rokka_time_link(); ?></span>
		</div>
		<h1 class="h3"><?php the_title(); ?></h1>
		<ul class="post-category">
			<?php echo rokka_categories_list(); ?>
		</ul>
		<?php the_content(); ?>
		<div class="page-clear">
			<?php
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'rokka' ),
					'after'  => '</div>',
				) );
			?>
		</div>
	</div>
	<footer>
		<?php $tags_list = get_the_tag_list('<li>', '</li><li>', '</li>'); ?>
		<?php if ( $tags_list ) : ?>
			<div class="post-cat-tags">
				<span style=""><?php echo esc_html__('Tags:', 'rokka'); ?></span><br/>
				<ul class="tags-list"><?php echo rokka_get_output($tags_list); ?></ul>
			</div>
		<?php endif; ?>
		<?php if(function_exists('rokka_get_share_links')) : ?>
			<?php echo rokka_get_share_links($shareData); ?>
		<?php endif ; ?>
	</footer>
</article>

<?php if(get_the_author_meta('description') !== '') : ?>
<section class="author-section">
	<div class="author-bio">
		<div class="author-avatar">
			<div style=""><?php echo mb_substr(get_the_author(),0,1); ?></div>
		</div>
		<div class="biography">
			<h5><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php echo get_the_author(); ?></a></h5>
			<div class="author-desc"><?php echo get_the_author_meta('description'); ?></div>
		</div>
	</div>
</section>
<?php endif; ?>
<footer>

	<?php
	echo rokka_get_post_navigation();
	
	if ( comments_open() || get_comments_number() ) :
		comments_template();
	endif;
	?>

</footer>


