<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_id
 * @var $el_class
 * @var $width
 * @var $css
 * @var $offset
 * @var $content - shortcode content
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Column
 */
$el_class = $el_id = $width = $css = $offset = $css_animation = $overlay_color = $overlay_color_hover = $parallax = $parallax_speed = $parallax_content = $parallax_image = $show_on_hover = $show_on_hover_class = $text_color = $parallax_speed_bg = $parallax_bg_size = '';
$output = '';
$aos_type = '';
$aos_delay = '0';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$width = rokka_translateColumnWidthToSpan( $width );
$width = vc_column_offset_class_merge( $offset, $width );

$css_classes = array(
	$this->getExtraClass( $el_class ) . $this->getCSSAnimation( $css_animation ),
	'wpb_column',
	'vc_column_container',
	$width,
);

if(strpos($css, 'margin-top: -')) {
	$css_classes[] = 'remove-mobile-margin';
}
if(strpos($css, 'margin-bottom: -')) {
	$css_classes[] = 'remove-mobile-margin';	
}

if ( vc_shortcode_custom_css_has_property( $css, array(
	'border',
	'background',
) ) ) {

}

$wrapper_attributes = array();

$parallax_speed = $parallax_speed_bg;

$parallax_content = '';
if ( ! empty( $parallax_image ) ) {
	$parallax_image_id = preg_replace( '/[^\d]/', '', $parallax_image );
	$parallax_image_src = wp_get_attachment_image_src( $parallax_image_id, 'large_bg' );
	if ( ! empty( $parallax_image_src[0] ) ) {
		$parallax_image_src = $parallax_image_src[0];
	}
}
if(!$parallax) {
	$parallax_speed = 1;
}
if($show_on_hover) {
	$show_on_hover_class = 'show-on-hover';
}
$overlay_hover = '';
$overlay_parent_hover_class = '';
if($overlay_color_hover) {
	$overlay_hover = '<div style="background-color: '.esc_attr($overlay_color_hover).';" class="column-overlay-hover"></div>';
	$overlay_parent_hover_class = 'column-hoverable';
}

if(!empty($parallax_image)) {
	// $parallax_content = '<div data-rokka-parallax="'.esc_attr( $parallax_speed ).'" style="background-image: url('.esc_url( $parallax_image_src ).'); background-size: '.esc_attr( $parallax_bg_size ).'" class="extended_bg rokka-parallax"></div>';


	if(!strpos($parallax_image, ',')) {
		$parallax_content = '<div data-rokka-parallax="'.esc_attr( $parallax_speed ).'" style="background-image: url('.esc_attr( $parallax_image_src ).')" class="extended_bg rokka-parallax"></div>';
	} else {
		$parallax_image = explode(',', $parallax_image);
		if(is_array($parallax_image)) {
			$slides = '';
			foreach ($parallax_image as $slider_image_id) {
				$slider_image_src = wp_get_attachment_image_src( $slider_image_id, 'large_bg' );
				if(!empty($slider_image_src[0] )) {
					$slider_image_src = $slider_image_src[0];
					$slides .= '<div data-slide="'.esc_url($slider_image_src).'"></div>';
				}
			}
			$parallax_content = '<div class="row-slides">'.$slides.'</div><div class="row-image-overlay"></div>'; 
		}
	}



}

if($text_color) {
	$text_color_style = 'style="color:'.esc_attr($text_color).';"';
} else {
	$text_color_style = '';
}

$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( $css_classes ) ), $this->settings['base'], $atts ) );
$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"  '.rokka_get_output($text_color_style).'';
if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}

$animation_attr = '';
if(function_exists('rokka_display_animation_attr')) {
	$animation_attr = rokka_display_animation_attr();
}
$output .= '<div ' . implode( ' ', $wrapper_attributes ) . '>';
$output .= '<div class="vc_column-inner ' . esc_attr( trim( vc_shortcode_custom_css_class( $css ) ) ) . ' '.esc_attr($show_on_hover_class).'" '.esc_attr($animation_attr).'>'.rokka_get_output($parallax_content);
if($overlay_parent_hover_class || $overlay_color || $overlay_hover) {
	$output .= '<div class="column-overlay '.esc_attr($overlay_parent_hover_class).'" style="background: '.esc_attr($overlay_color).'">'.rokka_get_output($overlay_hover).'</div>';
}
$output .= '<div class="wpb_wrapper">';
$output .= wpb_js_remove_wpautop( $content );
$output .= '</div>';
$output .= '</div>';
$output .= '</div>';


echo rokka_get_output($output);