<?php
/**
 * The template for displaying cart page.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/cart/cart.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.9.7.5
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

/**
 * @var $cart WPHB_Cart
 */
$cart = WP_Hotel_Booking::instance()->cart;
global $hb_settings; ?>

<?php if ( $cart->cart_items_count != 0 ) { ?>
	<div id="hotel-booking-cart">

		<form id="hb-cart-form" method="post">

			<h3><?php esc_html_e( 'Cart', 'rokka' ); ?></h3>

			<table class="hb_table">
				<thead>
				<tr>
					<th>&nbsp;</th>
					<th class="hb_room_type"><?php esc_html_e( 'Room type', 'rokka' ); ?></th>
					<th class="hb_capacity"><?php esc_html_e( 'Capacity', 'rokka' ); ?></th>
					<th class="hb_quantity"><?php esc_html_e( 'Quantity', 'rokka' ); ?></th>
					<th class="hb_check_in"><?php esc_html_e( 'Check - in', 'rokka' ); ?></th>
					<th class="hb_check_out"><?php esc_html_e( 'Check - out', 'rokka' ); ?></th>
					<th class="hb_night"><?php esc_html_e( 'Night', 'rokka' ); ?></th>
					<th class="hb_gross_total"><?php esc_html_e( 'Gross Total', 'rokka' ); ?></th>
				</tr>
				</thead>
				<?php if ( $rooms = $cart->get_rooms() ) { ?>
					<?php foreach ( $rooms as $cart_id => $room ) { ?>
						<?php
						/**
						 * @var $room WPHB_Room
						 */
						if ( ( $num_of_rooms = (int) $room->get_data( 'quantity' ) ) == 0 ) {
							continue;
						}
						$cart_extra = $cart->get_extra_packages( $cart_id ); ?>

						<tr class="hb_checkout_item" data-cart-id="<?php echo esc_attr( $cart_id ); ?>">
							<td<?php echo defined( 'WPHB_EXTRA_FILE' ) && $cart_extra ? ' rowspan="' . ( count( $cart_extra ) + 2 ) . '"' : '' ?>>
								<a href="javascript:void(0)" class="hb_remove_cart_item"
								   data-cart-id="<?php echo esc_attr( $cart_id ); ?>">
									<i class="fa fa-times"></i>
								</a>
							</td>
							<td class="hb_room_type">
								<a href="<?php echo get_permalink( $room->ID ); ?>"><?php echo apply_filters( 'hb_cart_room_name', $room->name, $room->ID ); ?><?php printf( '%s', $room->capacity_title ? ' (' . $room->capacity_title . ')' : '' ); ?></a>
							</td>
							<td class="hb_capacity"><?php echo sprintf( _n( '%d adult', '%d adults', $room->capacity, 'rokka' ), $room->capacity ); ?> </td>
							<td class="hb_quantity">
								<p><?php echo esc_html( $num_of_rooms ); ?></p>
							</td>
							<td class="hb_check_in"><?php echo date_i18n( hb_get_date_format(), strtotime( $room->get_data( 'check_in_date' ) ) ) ?></td>
							<td class="hb_check_out"><?php echo date_i18n( hb_get_date_format(), strtotime( $room->get_data( 'check_out_date' ) ) ) ?></td>
							<td class="hb_night"><?php echo hb_count_nights_two_dates( $room->get_data( 'check_out_date' ), $room->get_data( 'check_in_date' ) ) ?></td>
							<td class="hb_gross_total">
								<?php echo hb_format_price( $room->total ); ?>
							</td>
						</tr>
						<?php do_action( 'hotel_booking_cart_after_item', $room, $cart_id ); ?>
					<?php } ?>

				<?php } ?>

				<?php do_action( 'hotel_booking_before_cart_total' ); ?>

				<tr class="hb_sub_total">
					<td colspan="8"><?php esc_html_e( 'Sub Total', 'rokka' ); ?>
						<span class="hb-align-right hb_sub_total_value">
                                <?php echo hb_format_price( $cart->sub_total ); ?>
                            </span>
					</td>
				</tr>
				<?php if ( $tax = hb_get_tax_settings() ) { ?>
					<tr class="hb_advance_tax">
						<td colspan="8">
							<?php esc_html_e( 'Tax', 'rokka' ); ?>
							<?php if ( $tax < 0 ) { ?>
								<span><?php printf( esc_html__( '(price including tax)', 'rokka' ) ); ?></span>
							<?php } ?>
							<span class="hb-align-right"><?php echo apply_filters( 'hotel_booking_cart_tax_display', abs( $tax * 100 ) . '%' ); ?></span>
						</td>
					</tr>
				<?php } ?>
				<tr class="hb_advance_grand_total">
					<td colspan="8">
						<?php esc_html_e( 'Grand Total', 'rokka' ); ?>
						<span class="hb-align-right hb_grand_total_value"><?php echo hb_format_price( $cart->total ) ?></span>
					</td>
				</tr>
				<?php $advance_payment = ''; ?>
				<?php if ( $advance_payment = $cart->advance_payment ) : ?>
					<tr class="hb_advance_payment">
						<td colspan="8">
							<?php printf(__( 'Advance Payment (%s%% of Grand Total)', 'rokka' ), hb_get_advance_payment() ); ?>
							<span class="hb-align-right hb_advance_payment_value"><?php echo hb_format_price( $advance_payment ); ?></span>
						</td>
					</tr>
				<?php endif; ?>

				<tr>
					<?php wp_nonce_field( 'hb_cart_field', 'hb_cart_field' ); ?>
				</tr>
			</table>
			<p class="text-right">
				<a href="<?php echo hb_get_checkout_url() ?>"
				   class="btn-accent btn btn-sm btn-solid"><?php esc_html_e( 'Check Out', 'rokka' ); ?></a>
			</p>
		</form>
	</div>

<?php } else { ?>

	<div class="hb-ty-message">
		<div class="hb-ty-message-inner">
			<?php esc_html_e( 'Your cart is empty!', 'rokka' ) ?>
		
		</div>
	</div>
<?php } ?>
