<?php
/**
 * The template for displaying new customer form in checkout page.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/checkout/customer-new.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

/**
 * @var $customer
 */
?>

<div class="hb-order-new-customer" id="hb-order-new-customer">
    <div class="">
    	<div class="text-center">
	        <h4 class="heading-decorator-1 my-5"><?php esc_html_e( 'New Customer', 'rokka' ); ?></h4>
	    </div>
        <div class="row">
        <ul class="hb-form-table col-6">
            <li class="hb-form-field">
                <label class="hb-form-field-label"><?php esc_html_e( 'Title', 'rokka' ); ?>
                    <span class="hb-required">*</span> </label>

                <div class="hb-form-field-input">
					<?php hb_dropdown_titles( array( 'selected' => $customer->title, 'required' => true ) ); ?>
                </div>
            </li>
            <li class="hb-form-field">
                <label class="hb-form-field-label"><?php esc_html_e( 'First name', 'rokka' ); ?>
                    <span class="hb-required">*</span></label>

                <div class="hb-form-field-input">
                    <input type="text" name="first_name" value="<?php echo esc_attr( $customer->first_name ); ?>"
                           placeholder="<?php esc_attr_e( 'First name', 'rokka' ); ?>" required/>
                </div>
            </li>
            <li class="hb-form-field">
                <label class="hb-form-field-label"><?php esc_html_e( 'Last name', 'rokka' ); ?>
                    <span class="hb-required">*</span></label>

                <div class="hb-form-field-input">
                    <input type="text" name="last_name" value="<?php echo esc_attr( $customer->last_name ); ?>"
                           placeholder="<?php esc_attr_e( 'Last name', 'rokka' ); ?>" required/>
                </div>
            </li>
            <li class="hb-form-field">
                <label class="hb-form-field-label"><?php esc_html_e( 'Address', 'rokka' ); ?>
                    <span class="hb-required">*</span></label>

                <div class="hb-form-field-input">
                    <input type="text" name="address" value="<?php echo esc_attr( $customer->address ); ?>"
                           placeholder="<?php esc_attr_e( 'Address', 'rokka' ); ?>" required/>
                </div>
            </li>
            <li class="hb-form-field">
                <label class="hb-form-field-label"><?php esc_html_e( 'City', 'rokka' ); ?>
                    <span class="hb-required">*</span></label>

                <div class="hb-form-field-input">
                    <input type="text" name="city" value="<?php echo esc_attr( $customer->city ); ?>"
                           placeholder="<?php esc_attr_e( 'City', 'rokka' ); ?>" required/>
                </div>
            </li>
            <li class="hb-form-field">
                <label class="hb-form-field-label"><?php esc_html_e( 'State', 'rokka' ); ?>
                    <span class="hb-required">*</span></label>

                <div class="hb-form-field-input">
                    <input type="text" name="state" value="<?php echo esc_attr( $customer->state ); ?>"
                           placeholder="<?php esc_attr_e( 'State', 'rokka' ); ?>" required/>
                </div>
            </li>
        </ul>
        <ul class="hb-form-table col-6">
            <li class="hb-form-field">
                <label class="hb-form-field-label"><?php esc_html_e( 'Postal Code', 'rokka' ); ?>
                    <span class="hb-required">*</span></label>

                <div class="hb-form-field-input">
                    <input type="text" name="postal_code" value="<?php echo esc_attr( $customer->postal_code ); ?>"
                           placeholder="<?php esc_attr_e( 'Postal code', 'rokka' ); ?>" required/>
                </div>
            </li>
            <li class="hb-form-field">
                <label class="hb-form-field-label"><?php esc_html_e( 'Country', 'rokka' ); ?>
                    <span class="hb-required">*</span></label>

                <div class="hb-form-field-input">
					<?php hb_dropdown_countries( array(
						'name'             => 'country',
						'show_option_none' => esc_html__( 'Country', 'rokka' ),
						'selected'         => $customer->country,
						'required'         => true
					) ); ?>
                </div>
            </li>
            <li class="hb-form-field">
                <label class="hb-form-field-label"><?php esc_html_e( 'Phone', 'rokka' ); ?>
                    <span class="hb-required">*</span></label>

                <div class="hb-form-field-input">
                    <input type="text" name="phone" value="<?php echo esc_attr( $customer->phone ); ?>"
                           placeholder="<?php esc_attr_e( 'Phone Number', 'rokka' ); ?>" required/>
                </div>
            </li>
            <li class="hb-form-field">
                <label class="hb-form-field-label"><?php esc_html_e( 'Email', 'rokka' ); ?>
                    <span class="hb-required">*</span></label>

                <div class="hb-form-field-input">
                    <input type="email" name="email" value="<?php echo esc_attr( $customer->email ); ?>"
                           placeholder="<?php esc_attr_e( 'Email address', 'rokka' ); ?>" required/>
                </div>
            </li>
            <li class="hb-form-field">
                <label class="hb-form-field-label"><?php esc_html_e( 'Fax', 'rokka' ); ?></label>

                <div class="hb-form-field-input">
                    <input type="text" name="fax" value="<?php echo esc_attr( $customer->fax ); ?>"
                           placeholder="<?php esc_attr_e( 'Fax', 'rokka' ); ?>"/>
                </div>
            </li>
        </ul>
	    </div>
        <input type="hidden" name="existing-customer-id" value=""/>
    </div>
</div>