<?php
/**
 * The template for displaying content single room.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/content-single-room.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit(); 
global $hb_room;
global $hb_settings;

$price_display = apply_filters( 'hotel_booking_loop_room_price_display_style', $hb_settings->get( 'price_display' ) );
$prices        = hb_room_get_selected_plan( get_the_ID() );
$prices        = isset( $prices->prices ) ? $prices->prices : array();
$img_class = '';
?>
<?php
/**
 * hotel_booking_before_single_product hook
 */
do_action( 'hotel_booking_before_single_product' );
$galleries = $hb_room->get_galleries( false );
if ( post_password_required() ) {
	echo get_the_password_form();

	return;
} ?>

<div id="room-<?php the_ID(); ?>" <?php post_class( 'hb_single_room' ); ?>>

	<?php
	/**
	 * hotel_booking_before_loop_room_summary hook
	 */
	do_action( 'hotel_booking_before_single_room' );
	?>

	<div class="summary entry-summary">

		<?php

		/**
		 * hotel_booking_loop_room_price hook
		 */
		//do_action( 'hotel_booking_loop_room_price' );

		/**
		 * hotel_booking_single_room_gallery hook
		 */
		do_action( 'hotel_booking_single_room_gallery' ); ?>
		<section class="container">
			<div class="row">
				<section class="col-12 col-lg-8">
					<div class="stretch-left">
						<?php $galleries = $hb_room->get_galleries( false ); ?>
						<div class="intro-slider-img swiper-container">
							<div class="intro-slider-inner swiper-wrapper">
								<?php if($galleries) : ?>
									<?php $img_class = 'has_img'; ?>
									<?php if ( count($galleries) > 1 ) : ?>
										<?php foreach ( $galleries as $key => $gallery ) : ?>
											<div class="intro-slider-slide swiper-slide">
												<div class="intro-image"><img src="<?php echo esc_url($gallery['src']); ?>"/></div>
											</div>
										<?php endforeach; ?>
									<?php else : ?>
									<div class="intro-slider-slide">
										<div class="intro-image"><img src="<?php echo esc_url($galleries[0]['src']); ?>"/></div>
									</div>
									<?php endif; ?> 
								<?php else : ?>
									<div class="intro-slider-slide">
										<div class="intro-image"><img src="<?php echo esc_url(get_the_post_thumbnail_url( get_the_ID(), 'rokka-slider' )); ?>"/></div>
									</div>
							   <?php endif; ?> 
							</div>
						</div>
					</div>
					<div class="single-post single-room-post <?php echo esc_attr($img_class); ?>">
						<article class="post-content">
							<?php if ( $galleries && count($galleries) > 1 ) : ?>
							<div class="room-gallery-arrows">
								<span class="prev">
									<span class="arrow-prev"></span>
								</span>
								<span class="next">
									<span class="arrow-next"></span>
								</span>
							</div>
							<?php endif; ?> 
							<div class="post-content-wrapper">
								
								<div class="title">
									<h1 class="h3">
										<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
									</h1>
									<ul class="post-category">

									<?php 
										$args = array();
										$terms = wp_get_post_terms( get_the_ID(), 'hb_room_type', $args);  
										if (is_array($terms)) {
											foreach ($terms as $c => $category) {
												echo '<li><a href="' . esc_url(get_category_link($category->term_id)) . '" title="' . esc_attr($category->name) . '">' . esc_html($category->name) . '</a></li>';
											}
										} 
									?>
									</ul>
								</div>
				   
								<?php do_action( 'hotel_booking_single_room_infomation' ); ?>
							</div>
						</article>
					</div>
					<?php remove_action('hotel_booking_single_room_title', 'hotel_booking_single_room_title'); ?>
					<?php do_action( 'hotel_booking_after_single_room' ); ?>
					<?php do_action( 'hotel_booking_after_single_product' ); ?>
				</section>
				<aside class="col-12 col-lg-4 room-sidebar">
					<div class="room-sidebar-inner">
						<?php if ( $prices ): ?>
						<div class="price">
							<span class="room-price">
							<?php
								$min = min( $prices );
								$max = max( $prices );
								?>
							<?php if($min !== $max) : ?>
								<h3 class="header-inline"><em class="title-price"><?php esc_html_e( 'from', 'rokka' ); ?></em></h3>
							<?php else : ?>
								<h3 class="header-inline"><em class="title-price"><?php esc_html_e( 'price', 'rokka' ); ?></em></h3>
							<?php endif; ?>

							 <?php if ( $price_display === 'max' ) : ?>
								<strong class="price_value price_max"><?php echo hb_format_price( $max + ( hb_price_including_tax() ? ( $max * hb_get_tax_settings() ) : 0 ))?></strong>
							<?php elseif ( $price_display === 'min_to_max' && $min !== $max ) : ?>
								<strong class="price_value price_min_to_max">
									<?php echo hb_format_price( $min + ( hb_price_including_tax() ? ( $min * hb_get_tax_settings() ) : 0 )) ?> - <?php echo hb_format_price( $max + ( hb_price_including_tax() ? ( $max * hb_get_tax_settings() ) : 0 )) ?>
								</strong>

							<?php else : ?> 
								<strong class="price_value price_min"><?php echo hb_format_price( $min + ( hb_price_including_tax() ? ( $min * hb_get_tax_settings() ) : 0 ))  ?></strong>
							<?php endif; ?>
							</span>

							<span class="room-price-text"><?php esc_html_e( 'per night', 'rokka' ); ?></span>
						</div>
						<?php endif; ?>
					<?php 
					//echo do_shortcode('[rokka_hotel_booking]');

					?>

					<!-- SIDEBAR -->
					<?php if(is_active_sidebar('sidebar-room')) : ?>
						<?php dynamic_sidebar('sidebar-room'); ?>
					<?php endif; ?>
					</div>
				</aside>
			</div>
		</section>
	</div>
</div>


