<?php
/**
 * The template for displaying search room item loop.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/search/loop.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

global $hb_settings;
/**
 * @var $hb_settings WPHB_Settings
 */
$gallery         = $room->gallery;
$featured        = $gallery ? array_shift( $gallery ) : false;
$single_purchase = get_option( 'tp_hotel_booking_single_purchase' );
?>

<li class="hb-room clearfix">

    <form name="hb-search-results"
          class="hb-search-room-results <?php if($single_purchase) { echo 'single-purchase'; } ?>">
		<?php do_action( 'hotel_booking_loop_before_item', $room->post->ID ); ?>
        <div class="hb-room-content">
            <div class="hb-room-thumbnail">
				<?php if ( $featured ): ?>
                    <a class="hb-room-gallery"
                       data-lightbox="hb-room-gallery[<?php echo esc_attr( $room->post->ID ); ?>]"
                       data-title="<?php echo esc_attr( $featured['alt'] ); ?>"
                       href="<?php echo esc_attr( $featured['src'] ); ?>">
						<?php $room->getImage( 'catalog' ); ?>
                    </a>
				<?php endif; ?>
            </div>

            <div class="hb-room-info">
                <h3 class="hb-room-name">
                    <a href="<?php echo get_the_permalink( $room->ID ) ?>">
						<?php echo esc_html( $room->name ); ?>
                    </a>
                </h3>
                <ul class="hb-room-meta">
                    <li class="hb_search_capacity">
                        <label><?php esc_html_e( 'Capacity:', 'rokka' ); ?></label>
                        <div class=""><?php echo esc_html( $room->capacity ); ?></div>
                    </li>
                    <li class="hb_search_max_child">
                        <label><?php esc_html_e( 'Max Children:', 'rokka' ); ?></label>
                        <div><?php echo esc_html( $room->max_child ); ?></div>
                    </li>
                    <?php if ( ! $single_purchase ) { ?>
                        <li class="hb_search_quantity">
                            <label><?php esc_html_e( 'Quantity: ', 'rokka' ); ?></label>
                            <div>
                                <?php
                                hb_dropdown_numbers(
                                    array(
                                        'name'             => 'hb-num-of-rooms',
                                        'min'              => 1,
                                        'max'              => $room->post->available_rooms,
                                        'class'            => 'number_room_select'
                                    )
                                );
                                ?>
                            </div>
                        </li>
                    <?php } else { ?>
                        <select name="hb-num-of-rooms" class="number_room_select" style="display: none;">
                            <option value="1">1</option>
                        </select>
                    <?php } ?>
                    <li class="hb_search_price">
                        <!-- <label><?php //_e( 'Price:', 'rokka' ); ?></label> -->
                        <span class="hb_search_item_price"><?php echo hb_format_price( $room->amount_singular ); ?></span>
                        <div class="hb_view_price">
                            <a href=""
                               class="hb-view-booking-room-details"><?php esc_html_e( 'View price breakdown', 'rokka' ); ?></a>
							<?php hb_get_template( 'search/booking-room-details.php', array( 'room' => $room ) ); ?>
                        </div>
                    </li>
                    <li class="hb_search_add_to_cart">
                        <button class="hb_add_to_cart btn btn-accent btn-sm btn-solid"><?php esc_html_e( 'Select this room', 'rokka' ) ?></button>
                    </li>
                </ul>
            </div>
        </div>

		<?php wp_nonce_field( 'hb_booking_nonce_action', 'nonce' ); ?>
        <input type="hidden" name="check_in_date"
               value="<?php echo date( 'm/d/Y', hb_get_request( 'hb_check_in_date' ) ); ?>"/>
        <input type="hidden" name="check_out_date"
               value="<?php echo date( 'm/d/Y', hb_get_request( 'hb_check_out_date' ) ); ?>">
        <input type="hidden" name="room-id" value="<?php echo esc_attr( $room->post->ID ); ?>">
        <input type="hidden" name="hotel-booking" value="cart">
        <input type="hidden" name="action" value="hotel_booking_ajax_add_to_cart"/>

		<?php do_action( 'hotel_booking_loop_after_item', $room->post->ID ); ?>
    </form>

	<?php if ( ( isset( $atts['gallery'] ) && $atts['gallery'] === 'true' ) || $hb_settings->get( 'enable_gallery_lightbox' ) ) { ?>
		<?php hb_get_template( 'loop/gallery-lightbox.php', array( 'room' => $room ) ) ?>
	<?php } ?>
</li>