<?php
/**
 * The template for displaying search room form.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/search/search-form.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.9.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

$check_in_date  = hb_get_request( 'check_in_date' );
$check_out_date = hb_get_request( 'check_out_date' );
$adults         = hb_get_request( 'adults', 0 );
$max_child      = hb_get_request( 'max_child', 0 );
$uniqid         = uniqid();

?>

<div id="hotel-booking-search-<?php echo uniqid(); ?>" class="hotel-booking-search">
	<?php
	// display title widget or shortcode
	$atts = array();
	if ( $args && isset( $args['atts'] ) ) {
		$atts = $args['atts'];
	}
	if(!isset($btn_color)) {
		$btn_color = 'btn-accent';
	}

	if ( ! isset( $atts['show_title'] ) || strtolower( $atts['show_title'] ) === 'true' ) { ?>
        <h5><?php esc_html_e( 'Search your room', 'rokka' ); ?></h5>
	<?php } ?>

    <form name="hb-search-form" action="<?php echo esc_url(hb_get_url()); ?>"
          class="hb-search-form-<?php echo esc_attr( $uniqid ) ?>">
        <ul class="hb-form-table">
            <li class="hb-form-field">
            	<div>
					<?php hb_render_label_shortcode( $atts, 'show_label', esc_html__( 'Check-in', 'rokka' ), 'true' ); ?>
	                <div class="hb-form-field-input hb_input_field">
	                	<span class="day input-date"><?php echo date('d',current_time('timestamp')); ?></span>
	                	<span class="month input-date"><?php echo date('M',current_time('timestamp')); ?></span>
	                	<i class="fa fa-angle-down"></i>
	                    <input type="text" name="check_in_date" id="check_in_date_<?php echo esc_attr( $uniqid ); ?>" class="hb_input_date_check" value="<?php echo esc_attr( $check_in_date ); ?>"/>
	                </div>
	            </div>
            </li>

            <li class="hb-form-field">
            	<div>
					<?php hb_render_label_shortcode( $atts, 'show_label', esc_html__( 'Check-out', 'rokka' ), 'true' ); ?>
	                <div class="hb-form-field-input hb_input_field">
	                	<span class="day input-date"><?php echo date('d',current_time('timestamp')+86400); ?></span>
	                	<span class="month input-date"><?php echo date('M',current_time('timestamp')+86400); ?></span>
	                	<i class="fa fa-angle-down"></i>
	                    <input type="text" name="check_out_date" id="check_out_date_<?php echo esc_attr( $uniqid ) ?>"
	                           class="hb_input_date_check" value="<?php echo esc_attr( $check_out_date ); ?>"/>
	                </div>
	            </div>
            </li>

            <li class="hb-form-field">
            	<div>
					<?php hb_render_label_shortcode( $atts, 'show_label', esc_html__( 'Adults', 'rokka' ), 'true' ); ?>
	                <div class="hb-form-field-input">
	                	<span class="capacity">1</span>
						<?php
						hb_dropdown_numbers(
							array(
								'name'              => 'adults_capacity',
								'min'               => 1,
								'max'               => hb_get_max_capacity_of_rooms(),
								'selected'          => $adults,
								'option_none_value' => 0,
								'options'           => hb_get_capacity_of_rooms()
							)
						);
						?>
						<div class="hb-select__group"><span class="hb__goup"><i class="fa fa-angle-up"></i></span><span class="hb__godown"><i class="fa fa-angle-down"></i></span></div>
	                </div>
	            </div>
            </li>

            <li class="hb-form-field">
            	<div>
					<?php hb_render_label_shortcode( $atts, 'show_label', esc_html__( 'Children', 'rokka' ), 'true' ); ?>
	                <div class="hb-form-field-input">
	                	<span class="capacity">0</span>
						<?php
						hb_dropdown_numbers(
							array(
								'name'              => 'max_child',
								'min'               => 0,
								'max'               => hb_get_max_child_of_rooms(),
								'option_none_value' => 0,
								'selected'          => $max_child,
							)
						);
						?>
						<div class="hb-select__group"><span class="hb__goup"><i class="fa fa-angle-up"></i></span><span class="hb__godown"><i class="fa fa-angle-down"></i></span></div>
	                </div>
	            </div>
            </li>
        </ul>
		<?php wp_nonce_field( 'hb_search_nonce_action', 'nonce' ); ?>
        <input type="hidden" name="hotel-booking" value="results"/>
        <input type="hidden" name="widget-search"
               value="<?php echo isset( $atts['widget_search'] ) ? $atts['widget_search'] : false; ?>"/>
        <input type="hidden" name="action" value="hotel_booking_parse_search_params"/>
        <p class="hb-submit">
            <button class="btn btn-solid btn-sm <?php echo esc_attr($btn_color); ?>" type="submit"><?php esc_html_e( 'Book now', 'rokka' ); ?></button>
        </p>
    </form>
</div>