<?php
/**
 * The template for displaying single room details.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/single-room/details.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();
$room = WPHB_Room::instance( get_the_ID() );
$galleries = get_post_meta( $room->post->ID, '_hb_gallery', true );
?>

<div class="hb_single_room_details">
	<?php if(get_the_content() != ''): ?>
	   <div class="description"><?php the_content(); ?></div>
	<?php endif; ?>
	<?php if($room->addition_information != '') : ?>
		<div class="additional-info">
			<h5><?php echo esc_html__( 'Additional Information', 'rokka' ); ?></h5>
			<?php echo rokka_get_output($room->addition_information); ?>
		</div>
	<?php endif; ?>
	<?php if ( $galleries ) : ?>
		<div class="room-gallery">
			<div class="grid grid-3">
				<?php foreach ( $galleries as $key => $gallery ) : ?>
					<?php  
						$image = wp_get_attachment_image_src( $gallery, 'full' );
						$thumbnail = wp_get_attachment_image_src( $gallery, 'rokka-square');
					?>
					<div class="room-image"><a href="<?php echo esc_url($image[0]); ?>"><img src="<?php echo esc_url($thumbnail[0]); ?>" width="<?php esc_attr($thumbnail[1]);?>px" height="<?php esc_attr($thumbnail[2]);?>px"/></a></div>
				<?php endforeach; ?>
			</div>
		</div>
	<?php endif; ?>
	<div class="pricing-plan">
		<?php do_action('hotel_booking_single_room_before_tabs_content_hb_room_pricing_plans'); ?>
	</div>
	<?php
	if(class_exists('WP_Hotel_Booking_Room_Extension')) {
		$booknow = WP_Hotel_Booking_Room_Extension::instance();
		$booknow->get_template( 'single-search-button.php' );
	}

	?>

	<div class="room-reviews">
		<?php do_action('hotel_booking_single_room_before_tabs_content_hb_room_reviews'); ?>
	</div>
</div>
