<?php
/**
 * The template for displaying single room gallery.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/single-room/gallery.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

global $hb_room;
global $hb_settings;
/**
 * @var $hb_room WPHB_Room
 */
$galleries = $hb_room->get_galleries( false );
$price_display = apply_filters( 'hotel_booking_loop_room_price_display_style', $hb_settings->get( 'price_display' ) );
$prices        = hb_room_get_selected_plan( get_the_ID() );
$prices        = isset( $prices->prices ) ? $prices->prices : array();
?>

<section class="d-none">
	<div class="intro-slider intro-section intro-single-room">
		<div class="intro-slider-img swiper-container">
			<div class="intro-slider-inner swiper-wrapper">
				<?php if ( $galleries ) : ?>
					<?php foreach ( $galleries as $key => $gallery ) : ?>
						<div class="intro-slider-slide swiper-slide">
							<div class="intro-image"><img src="<?php echo esc_url($gallery['src']); ?>"/></div>
						</div>
					<?php endforeach; ?>
					<?php else : ?>
						<div class="intro-slider-slide">
							<div class="intro-image"><img src="<?php echo esc_url(get_the_post_thumbnail_url( get_the_ID(), 'rokka-slider' )); ?>"/></div>
						</div>
					<?php endif; ?> 
				</div>
			</div>
			<div class="intro-slider-content swiper-container intro-content-bar">
				<div class="btn-reservation"></div>
				<div class="intro-content">
					<div class="mb-0">
						<?php if ( $prices ) {
							$min = min( $prices );
							$max = max( $prices );
							?>

							<div class="price">
								<?php if($min !== $max) : ?>
									<span class="title-price"><?php esc_html_e( 'From', 'rokka' ); ?></span>
									<?php else : ?>
										<span class="title-price"><?php esc_html_e( 'Price', 'rokka' ); ?></span>
									<?php endif; ?>
									<?php if ( $price_display === 'max' ) : ?>
										<span class="price_value price_max"><?php echo hb_format_price( $max ) ?></span>

										<?php elseif ( $price_display === 'min_to_max' && $min !== $max ) : ?>
											<span class="price_value price_min_to_max">
												<?php echo hb_format_price( $min ) ?> - <?php echo hb_format_price( $max ) ?>
											</span>

											<?php else : ?>
												<span class="price_value price_min"><?php echo hb_format_price( $min ) ?></span>
											<?php endif; ?>

											<span class="unit"><?php esc_html_e( 'night', 'rokka' ); ?></span>
										</div>
									<?php } ?>
								</div>
							</div>

							<div class="slider-nav">
								<?php if ( $galleries && count($galleries) > 1) : ?>
									<div class="arrow-prev"><div></div></div>
									<div class="swiper-pagination "></div>
									<div class="arrow-next "><div></div></div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</section>