<?php
/**
 * The template for displaying single room review.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/single-room/review.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$rating   = intval( get_comment_meta( $comment->comment_ID, 'rating', true ) );
$settings = WPHB_Settings::instance();
?>

<li itemprop="review" itemscope itemtype="http://schema.org/Review" <?php comment_class(); ?>
id="li-comment-<?php comment_ID() ?>">

<!-- <div id="comment-<?php //comment_ID(); ?>" class="comment_container"> -->
	<div class="comment-author vcard">
		<?php 
		if(get_avatar( $comment, apply_filters( 'hb_review_gravatar_size', '60' ), 'default' )) {
			echo get_avatar( $comment, apply_filters( 'hb_review_gravatar_size', '60' ), '' ); 
		} else {
			echo '<div class="comment-author-avatar">';
			echo substr(comment_author(), 0, 1);
			echo '</div>';
		}
		?>
		<div class="comment-header comment-content">
			<?php if ( $comment->comment_approved == '0' ) { ?>
				<p class="meta"><em><?php esc_html_e( 'Your comment is awaiting approval', 'rokka' ); ?></em></p>
			<?php } else { ?>
				<div class="author-header">
					<div class="comment-author-link"><?php comment_author(); ?></div>
					<div class="comment-date comment-meta commentmetadata">
						<time itemprop="datePublished" datetime="<?php echo get_comment_date( 'c' ); ?>"><?php echo get_comment_date( hb_date_format() ); ?></time>
					</div>
				</div>
			<?php } ?>
			<?php if ( $rating && $settings->get( 'enable_review_rating' ) ) { ?>
				<div itemprop="reviewRating" itemscope itemtype="http://schema.org/Rating" class="star-rating"
				title="<?php echo sprintf(__( 'Rated %d out of 5', 'rokka' ), $rating ) ?>">
				<?php $ratingWidth = ($rating / 5) * 100; ?>
				<span style="width:<?php echo esc_attr($ratingWidth); ?>%"></span>
			</div>
		<?php } ?>

		<div itemprop="description" class="comment-body"><?php comment_text(); ?></div>
	</div>
</div>
<!-- </div> -->
</li>