<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package rokka
 */

?>

</div>

<?php 

	if(function_exists('get_field')) :
		$footer = '';
		if(get_field('rokka_page_select_footer')) {
			$footer = get_field('rokka_page_select_footer');
		} elseif(get_field('rokka_select_footer', 'option')) {
			$footer = get_field('rokka_select_footer', 'option');
		}

		if($footer) : ?>
			<footer class="page-footer">
				<div class="footer-row-wrapper">
					<div class="container">
						<?php
						$footerContent = apply_filters('rokka_the_content', $footer->post_content);
						$footerContent = str_replace( ']]>', ']]&gt;', $footerContent );
						echo rokka_get_output($footerContent);
						?>
					</div>
				</div>
			</footer>
		<?php endif; ?> 

	<?php else: ?>
			<footer class="page-footer">
				<div class="footer-row-wrapper">
					<div class="container text-center pt-5 pb-5">
						<?php if( get_theme_mod( 'rokka_footer_text_block') != "" ): ?>
							<p class="footer-text">
								<?php echo get_theme_mod( 'rokka_footer_text_block'); ?>
							</p>
						<?php endif; ?>
					</div>
				</div>
			</footer>

	<?php endif; ?>
	<?php if(function_exists('get_field')) : ?>
	<?php if(get_field('rokka_back_top', 'option') == true) : ?>
		<a id="scroll-up" class="scroll-up show-for-medium">
			<div class="arrow">
				<i class="fa fa-angle-up"></i>
				<span></span>
			</div>
		</a>
	<?php endif; ?>
	<?php endif; ?>

<?php wp_footer(); ?>


</body>
</html>
