<?php
require get_template_directory() . '/inc/global-functions.php';
require get_template_directory() . '/inc/enqueue-scripts.php';
require get_template_directory() . '/inc/template-tags.php';
require get_template_directory() . '/inc/template-functions.php';
require get_template_directory() . '/inc/class-tgm-plugin-activation.php';
require get_template_directory() . '/inc/customizer.php';
require get_template_directory() . '/inc/comment-functions.php';

add_filter( 'nav_menu_css_class', 'rokka_menu_item_classes', 10, 4 );

function rokka_menu_item_classes( $classes, $item, $args, $depth ) {
	$classes[] = 'nav-item';

	return $classes;
}


if( function_exists('acf_add_options_page') ) {
	$parent = acf_add_options_page(array(
		'page_title' 	=> esc_html__('Theme Settings', 'rokka'),
		'menu_title' 	=> esc_html__('Theme Settings', 'rokka'),
		'menu_slug'     => 'acf-options',
		'redirect' 		=> false,
		'autoload'      => true,
	));

	acf_add_options_sub_page(array(
		'page_title' 	=> esc_html__('Typography', 'rokka'),
		'menu_title' 	=> esc_html__('Typography', 'rokka'),
		'parent_slug' 	=> $parent['menu_slug'],
	));

	if( !defined('ROKKA_SHOW_ACF') ) {
		add_filter('acf/settings/show_admin', '__return_false');
	}
}


