<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package rokka
 */

function rokka_body_classes( $classes ) {
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'rokka_body_classes' );

function rokka_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'rokka_pingback_header' );

function rokka_translateColumnWidthToSpan( $width ) {
	preg_match( '/(\d+)\/(\d+)/', $width, $matches );

	if ( ! empty( $matches ) ) {
		$part_x = (int) $matches[1];
		$part_y = (int) $matches[2];
		if ( $part_x > 0 && $part_y > 0 ) {
			$value = ceil( $part_x / $part_y * 12 );
			if ( $value > 0 && $value <= 12 ) {
				$width = 'vc_col-md-' . $value;
			}
		}
	}

	return $width;
}
function rokka_formats_button($buttons) {
	array_unshift($buttons, 'styleselect');

	return $buttons;
}

add_filter('mce_buttons', 'rokka_formats_button');

function rokka_mce_before_init_insert_formats($init_array) {

	$style_formats = array(  
		array(
			'title' => 'Font weight 100',  
			'inline' => 'span',  
			'styles' => array('font-weight' => '100'),
		),
		array(
			'title' => 'Font weight 200',  
			'inline' => 'span',  
			'styles' => array('font-weight' => '200'),
		),
		array(
			'title' => 'Font weight 300',  
			'inline' => 'span',  
			'styles' => array('font-weight' => '300'),
		),
		array(
			'title' => 'Font weight 400',  
			'inline' => 'span',  
			'styles' => array('font-weight' => '400'),
		),
		array(
			'title' => 'Font weight 500',  
			'inline' => 'span',  
			'styles' => array('font-weight' => '500'),
		),
		array(
			'title' => 'Font weight 600',  
			'inline' => 'span',  
			'styles' => array('font-weight' => '600'),
		),
		array(
			'title' => 'Font weight 700',  
			'inline' => 'span',
			'styles' => array('font-weight' => '700'),
		),
		array(
			'title' => 'Font weight 800',  
			'inline' => 'span',
			'styles' => array('font-weight' => '800'),
		),
		array(
			'title' => 'Font weight 900',  
			'inline' => 'span',  
			'styles' => array('font-weight' => '900'),
		),
	);
	$init_array['style_formats'] = json_encode( $style_formats );  
	$sizes = '';
	for($size = 10; $size <= 160; $size+=2) {
		$sizes .= ' '.$size.'px';
	}
	$init_array['fontsizeselect'] = true;
	$init_array['fontsize_formats'] = $sizes;
	return $init_array;
}

add_filter('tiny_mce_before_init', 'rokka_mce_before_init_insert_formats');

if ( ! function_exists( 'rokka_mce_buttons' ) ) {
	function rokka_mce_buttons( $buttons ) {
		array_push( $buttons, 'fontsizeselect' );
		return $buttons;
	}
}
add_filter( 'mce_buttons_2', 'rokka_mce_buttons' );

add_action('admin_init', 'rokka_add_button');

function rokka_add_button() {
	if (current_user_can('edit_posts') && current_user_can('edit_pages')) {
		add_filter('mce_external_plugins', 'rokka_add_plugin');
		add_filter('mce_buttons_2', 'rokka_register_button');
	}
}
add_filter('mce_buttons_2', 'rokka_register_button');
function rokka_register_button($buttons) {
	array_push($buttons, "rokka");
	return $buttons;
}
function rokka_add_plugin($plugin_array) {
	$plugin_array['rokka'] = get_template_directory_uri(). '/inc/tinymce/shortcodes.js';
	return $plugin_array;
}

function rokka_excerpt_more( $more ) {
	return esc_html__('[...]', 'rokka').' <a href="'.get_the_permalink().'" class="more-link">'.esc_html__('Continue reading', 'rokka').'</a>';
}
add_filter('excerpt_more', 'rokka_excerpt_more');

function rokka_image_preloader($width, $height) {
	return 'data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D&#039;http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg&#039;%20viewBox%3D&#039;0%200%20'.$width.'%20'.$height.'&#039;%2F%3E';
}

function rokka_get_output($output) {
	return $output;
}


add_filter( 'comment_form_defaults', 'rokka_custom_reply_title' );
function rokka_custom_reply_title( $defaults ){
	$defaults['title_reply_before'] = '<h2 id="reply-title" class="h4 comment-reply-title">';
	$defaults['title_reply_after'] = '</h2>';
	return $defaults;
}

function rokka_vc_active() {
	$post = get_post();
	if ( $post && preg_match( '/vc_row/', $post->post_content ) ) {
		return true;
	}
	return false;
}