<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package rokka
 */

if ( ! function_exists( 'rokka_sticked_post' ) ) :
	function rokka_sticked_post() {
		if(is_sticky()) {
			echo '<span class="sticked-post-label"><i class="fa fa-thumbtack"></i>'.esc_html__('Sticked', 'rokka').'</span>';
		}
	}
endif;

if ( ! function_exists( 'rokka_time_link' ) ) :
function rokka_time_link() {
	$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
	$time_string = sprintf( $time_string,
		get_the_date( DATE_W3C ),
		get_the_date()
	);
	return '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>';
}
endif;
if ( ! function_exists( 'rokka_posted_on' ) ) :
	function rokka_posted_on($id = null) {
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time>';
		}

		$time_string = sprintf( $time_string,
			esc_attr( get_the_date( DATE_W3C ) ),
			esc_html( get_the_date() )
		);
		if(is_sticky()) {
			$time_string = '<i class="fas fa-thumbtack mr-2"></i>'.$time_string;
		}
		$posted_on = '<a href="' . esc_url( get_permalink($id) ) . '" rel="bookmark">' . $time_string . '</a>';

		return wp_kses($posted_on, array(
			'a'=>array(
				'href'=>array(),
				'rel'=>array()
			),
			'time'=>array(
				'class'=>array(),
				'datetime'=>array()
			),
			'i'=>array('class'=>array())
		)); 
	}
endif;
if ( ! function_exists( 'rokka_categories_list' ) ) :
	function rokka_categories_list() {
		$categories_list = '';
		$postCats = get_the_category(); 
		if (is_array($postCats)) {
			foreach ($postCats as $c => $category) {
				$categories_list .= '<li class="cat-item"><a class="rokka-category" href="' . esc_url(get_category_link($category->term_id)) . '" title="' . esc_attr($category->name) . '">' . esc_html($category->name) . '</a></li>';
			}
		} 
		echo rokka_get_output($categories_list);
	}
endif;

if ( ! function_exists( 'rokka_entry_footer' ) ) :
	function rokka_entry_footer() {
		if ( 'post' === get_post_type() ) {
			$categories_list = get_the_category_list( esc_html__( ', ', 'rokka' ) );
			if ( $categories_list ) {
				printf( '<span class="cat-links">' . esc_html__( 'Posted in %1$s', 'rokka' ) . '</span>', $categories_list ); // WPCS: XSS OK.
			}

			$tags_list = get_the_tag_list( '', esc_html_x( ', ', 'list item separator', 'rokka' ) );
			if ( $tags_list ) {
				printf( '<span class="tags-links">' . esc_html__( 'Tagged %1$s', 'rokka' ) . '</span>', $tags_list ); // WPCS: XSS OK.
			}
		}

		if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<span class="comments-link">';
			comments_popup_link(
				sprintf(
					wp_kses(
						__( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'rokka' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				)
			);
			echo '</span>';
		}
	}
endif;

if ( ! function_exists( 'rokka_post_thumbnail' ) ) :
	function rokka_post_thumbnail($size = 'large') {
		if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
			return;
		}

		if ( is_single() ) :
			?>
			<div class="post-thumbnail">
				<?php the_post_thumbnail($size); ?>
			</div>
		<?php else : ?>

		<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
			<?php
			the_post_thumbnail( $size, array(
				'alt' => the_title_attribute( array(
					'echo' => false,
				) ),
			) );
			?>
		</a>

		<?php
		endif;
	}
endif;

function rokka_post_grid_category() {
	if ( 'post' === get_post_type() ) {
		$categories_list = get_the_category_list( esc_html__( ', ', 'rokka' ) );
		if ( $categories_list ) {
			echo '<span class="cat-links">' . $categories_list . '</span>';
		}

	}
}

function rokka_posted_on_grid() {
	$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
		$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time>';
	}

	$time_string = sprintf( $time_string,
		esc_attr( get_the_date( DATE_W3C ) ),
		esc_html( get_the_date() )
	);

	$posted_on = '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>';
	echo '<span class="posted-on">'. $posted_on . '</span>';
}

function rokka_get_post_navigation() {
	$navigation = $previous = $next = '';
 	
 	$prevPost = get_previous_post();
 	$nextPost = get_next_post();

 	if($prevPost) {
	 	$prevImage = get_the_post_thumbnail( $prevPost->ID, 'thumbnail' );
		$previous = get_previous_post_link(
			'<div class="prev-post">
				<div class="prev-img">
					'.(($prevImage) ? $prevImage : '<h3 class="h5">'.substr($prevPost->post_title, 0, 1).'</h3>').'
				</div>
				<div class="prev-post-content">
					<h6>%link</h6>
					<div class="post-date">'.rokka_posted_on($prevPost->ID).'</div>
				</div>
			</div>'
		);
 	}
 
	if($nextPost) {
	 	$nextImage = get_the_post_thumbnail( $nextPost->ID, 'thumbnail' );
		$next = get_next_post_link(
			'<div class="next-post">
				<div class="next-img">
					'.(($nextImage) ? $nextImage : '<h3 class="h5">'.substr($nextPost->post_title, 0, 1).'</h3>').'
				</div>
				<div class="next-post-content">
					<h6>%link</h6>
					<div class="post-date">'.rokka_posted_on($nextPost->ID).'</div>
				</div>
			</div>'
		);
	}
 
	if ( $previous || $next ) {
		$navigation = _navigation_markup( $previous . $next, 'prev-next-posts', 'Post navigation' );
	}
 
	return $navigation;
}