<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package rokka
 */

get_header();
$colOffset = '';
$col = 8;
if ( !is_active_sidebar( 'sidebar-blog' ) ) {
	$col = 12;
}
$sidebar = 'show';
$post_class = '';
if(function_exists('get_field')) {
	if(get_field('rokka_blog_sidebar', 'option') == true) {
		$sidebar = 'show';
		$post_class .= 'post-with-sidebar large-with-sidebar sidebar-on';
	} else { 
		$sidebar = 'hide';
		$post_class .= 'post-without-sidebar';
	}
} else {
	if(is_active_sidebar('sidebar-blog')) {
		$sidebar = 'show';
		$post_class .= 'post-with-sidebar large-with-sidebar sidebar-on';
	} else {
		$sidebar = 'hide';
		$post_class .= 'post-without-sidebar';		
	}
}
?>

<section class="container">
	<div class="row">
		<section class="col-12 col-lg-<?php echo esc_attr($col); ?> <?php echo esc_attr($colOffset); ?>">
			<div class="blog blog-standard <?php echo esc_attr( $post_class ); ?> mt-5">
				<div class="blog-content">
				<?php
				if ( have_posts() ) :

					if ( is_home() && ! is_front_page() ) :
						?>
						<header>
							<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
						</header>
						<?php
					endif;


					while ( have_posts() ) :
						the_post();
						get_template_part( 'template-parts/content', 'list' );

					endwhile;

					the_posts_pagination(array(
		    			'prev_text' => '<div class="previous-page arrow arrow-prev">&larr;</div>',
		    			'next_text' => '<div class="next-page arrow arrow-next">&rarr;</div>',
					)); 

				else :

					get_template_part( 'template-parts/content', 'none' );

				endif;
				?>
				</div>
			</div>
		</section>
		<?php if(is_active_sidebar('sidebar-blog') && $sidebar == 'show') : ?>
			<aside class="col-12 col-lg-4">
				<div class="blog-sidebar mt-5">
					<?php dynamic_sidebar('sidebar-blog'); ?>
				</div>
			</aside>
		<?php endif; ?>
	</div>
</section>

<?php

get_footer();
