<?php
/*
Template Name: Blog list
 */

get_header(); 

if ( get_query_var('paged') ) { $paged = get_query_var('paged'); }
elseif ( get_query_var('page') ) { $paged = get_query_var('page'); }
else { $paged = 1; }

$perpage = get_option('posts_per_page');

$query_params = array(
	'post_type' => 'post',
	'paged' => $paged,
	'posts_per_page' => $perpage,
	'ignore_sticky_posts' => true

);

$colOffset = '';
if ( !is_active_sidebar( 'sidebar-blog' ) ) {
	$colOffset = 'offset-lg-2';
}
$sidebar = 'show';
$post_class = '';
if(function_exists('get_field')) {
	if(get_field('rokka_blog_sidebar', 'option') == true) {
		$sidebar = 'show';
		$post_class .= 'post-with-sidebar large-with-sidebar sidebar-on';
	} else { 
		$sidebar = 'hide';
		$post_class .= 'post-without-sidebar';
	}
} else {
	if(is_active_sidebar('sidebar-blog')) {
		$sidebar = 'show';
		$post_class .= 'post-with-sidebar large-with-sidebar sidebar-on';
	} else {
		$sidebar = 'hide';
		$post_class .= 'post-without-sidebar';		
	}
}

$wp_query = new WP_Query( $query_params );
?>
	<div class="container blog-list-wrapper">
		<div class="row">
			<div class="col-12 col-lg-8 <?php echo esc_attr($colOffset); ?>">
				<div class="blog blog-standard <?php echo esc_attr( $post_class ); ?> mt-5">
					<div class="blog-content">
					<?php
					if ( $wp_query->have_posts() ) :
						while ( $wp_query->have_posts() ) :
							$wp_query->the_post();
							get_template_part( 'template-parts/content', 'list' );
						endwhile;
						the_posts_pagination(array(
			    			'prev_text' => '<div class="previous-page arrow arrow-prev">&larr;</div>',
			    			'next_text' => '<div class="next-page arrow arrow-next">&rarr;</div>',
						)); 
						wp_reset_postdata();
					else :
						get_template_part( 'template-parts/content', 'none' );
					endif;
					?>
					</div>
				</div>
			</div>
			<?php if(is_active_sidebar('sidebar-blog') && $sidebar == 'show') : ?>
				<aside class="col-12 col-lg-4">
					<div class="blog-sidebar mt-5">
						<?php dynamic_sidebar('sidebar-blog'); ?>
					</div>
				</aside>
			<?php endif; ?>
		</div>
	</div>
<?php

get_footer();
