
<?php
$overContent = '';
$logo_height_small = 80;
if(function_exists('get_field')) {
	if(get_field('rokka_navigation_over_content')) {
		$overContent = 'over-content';
	}
	$logo_height_small = get_field('rokka_logo_max_height_small', 'option');
} 

$startNavigation = 'nav-dark';

if(function_exists('get_field')) {
	if(get_field('rokka_navigation_light_on_start')){
		$startNavigation = 'nav-light';
	}
}
?>


<nav class="navbar <?php echo esc_attr($startNavigation); ?> <?php echo esc_attr($overContent);?>" data-nav-start="<?php echo esc_attr($startNavigation); ?>" data-height-scroll="<?php echo esc_attr($logo_height_small); ?>">
	<header class="main-logo logo-img d-flex" style="justify-content: center; align-items: center;">
	<?php if(function_exists('get_field')) {
		if(get_field('rokka_upload_logo', 'option')) {
			if(get_field('rokka_navigation_light_on_start')) {
				$logo = get_field('rokka_upload_logo_light', 'option');
			} else {
				$logo = get_field('rokka_upload_logo', 'option');
			}
			$logoScroll = get_field('rokka_upload_logo_small', 'option');
			$maxWidth = get_field('rokka_logo_max_width', 'option');
			echo '<h1><a class="site-header-logo" href="'.esc_url( home_url( '/' ) ).'">
			<img src="'.esc_url($logo['url']).'" class="logo-start" alt="'.esc_attr(get_bloginfo( 'name' )).'">
			<img src="'.esc_url($logoScroll['url']).'" class="logo-small" alt="'.esc_attr(get_bloginfo( 'name' )).'">
			</a></h1>';
		} else {
			echo '<h1 class="text-logo"><a class="site-header-logo" href="'.esc_url( home_url( '/' )).'">'.esc_html(get_bloginfo('name')).'</a></h1>';
		}
	} else {
		echo '<h1 class="text-logo"><a class="site-header-logo" href="'.esc_url( home_url( '/' )).'">'.esc_html(get_bloginfo('name')).'</a></h1>';
	}; ?>
	</header>		

	<div>
	<?php
		wp_nav_menu( array(
			'theme_location' => 'menu-1',
			'menu_class' => 'navbar-nav navbar-first-level d-none d-lg-flex',
		) );
		?>
		
		<div class="d-none d-lg-flex nav-social-wrapper">
			<?php
			if(function_exists('get_field')) {
				$socialLinks = get_field('rokka_navigation_social_icons', 'options');
				if(!empty($socialLinks)) {
					foreach ($socialLinks as $social) {
						if(isset($social['social_link']) && $social['icon_class']) {
							echo '<div class="ml-3"><a href="'.$social['social_link'].'"><i class="fab '.$social['icon_class'].'"></i></a></div>';
						}
					}
				}
			} ?>
			
			<?php rokka_navbar_languages(); ?>
			
		</div>
		
		<div class="burger-nav d-lg-none"></div>
	</div>
</nav>
<div class="nav-overlay">
	<div class="overlay-nav-header">
		<header class="main-logo">
			<h1><a href="#"><span><?php echo esc_html(get_bloginfo( 'name' )); ?></span></a></h1>
		</header>
		<div class="burger-nav"></div>
	</div>
	<div class="overlay-nav-content">
		<?php if(function_exists('get_field')) : ?>
			<div class="overlay-content">
				<?php if(get_field('rokka_navigation_mobile_info', 'options')) : ?>
					<?php echo wpautop(get_field('rokka_navigation_mobile_info', 'options')); ?>
				<?php endif; ?>
				<?php rokka_mobile_languages(); ?>
			</div>
		<?php endif; ?>

		<?php
		wp_nav_menu( array(
			'theme_location' => 'menu-1',
			'menu_class' => 'navbar-nav navbar-first-level',
			'container_class' => 'navbar',
		) );
		?>
	</div>
</div>