<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $full_width
 * @var $full_height
 * @var $equal_height
 * @var $columns_placement
 * @var $content_placement
 * @var $parallax
 * @var $parallax_image
 * @var $css
 * @var $el_id
 * @var $video_bg
 * @var $video_bg_url
 * @var $video_bg_parallax
 * @var $parallax_speed_bg
 * @var $parallax_speed_video
 * @var $content - shortcode content
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Row
 */
$el_class = $full_height = $parallax_speed_bg = $parallax_speed_video = $full_width = $equal_height = $flex_row = $columns_placement = $content_placement = $parallax = $parallax_image = $css = $el_id = $video_bg = $video_bg_url = $video_bg_parallax = $css_animation = $overlay_color = $img_pattern = $text_color = $tooltip_fullpage = $plus_color = '';
$video_start = 0;
$disable_element = '';
$output = $after_output = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );
if(isset($atts['video_start'])) {
	$video_start = $atts['video_start'];
}

wp_enqueue_script( 'wpb_composer_front_js' );

$el_class = $this->getExtraClass( $el_class ) . $this->getCSSAnimation( $css_animation );

$css_classes = array(
	'vc_row',
	'wpb_row',
	//deprecated
	'vc_row-fluid',
	$el_class,
	vc_shortcode_custom_css_class( $css ),
);
if(strpos($css, 'margin-top: -')) {
	$css_classes[] = 'remove-mobile-margin';
}
if(strpos($css, 'margin-bottom: -')) {
	$css_classes[] = 'remove-mobile-margin';	
}
$css_classes = array_unique($css_classes);

if ( 'yes' === $disable_element ) {
	if ( vc_is_page_editable() ) {
		$css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
	} else {
		return '';
	}
}

if ( vc_shortcode_custom_css_has_property( $css, array(
		'border',
		'background',
	) ) || $video_bg || $parallax
) {

}

if ( !empty( $atts['gap'] ) ) {
	if($atts['gap'] == 'remove-gap') {
		$css_classes[] = 'remove-gap';
	} else {
		$css_classes[] = 'vc_column-gap-' . $atts['gap'];
	}
}

$wrapper_attributes = array();
// build attributes for wrapper
if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}


if ( ! empty( $full_width ) ) {
	if('stretch_row_right' == $full_width) {
		$wrapper_attributes[] = 'data-vc-stretch-side="right"';
	} elseif('stretch_row_left' == $full_width) {
		$wrapper_attributes[] = 'data-vc-stretch-side="left"';
	} else {
		$wrapper_attributes[] = 'data-vc-full-width="true"';
	}
	$wrapper_attributes[] = 'data-vc-full-width-init="false"';
	if ($full_width === 'stretch_row_content') {
		$wrapper_attributes[] = 'data-vc-stretch-content="true"';
	} elseif ($full_width === 'stretch_row_content_no_spaces') {
		$wrapper_attributes[] = 'data-vc-stretch-content="true"';
		$css_classes[] = 'vc_row-no-padding';
	}
	$after_output .= '<div class="vc_row-full-width vc_clearfix"></div>';
}

if ( ! empty( $full_height ) ) {
	$css_classes[] = 'vc_row-o-full-height';
	if ( ! empty( $columns_placement ) ) {
		$flex_row = true;
		$css_classes[] = 'vc_row-o-columns-' . $columns_placement;
		if ($columns_placement === 'stretch') {
			$css_classes[] = 'vc_row-o-equal-height';
		}
	}
}

if ( ! empty( $equal_height ) ) {
	$flex_row = true;
	$css_classes[] = 'vc_row-o-equal-height';
}

if ( ! empty( $content_placement ) ) {
	$flex_row = true;
	$css_classes[] = 'vc_row-o-content-' . $content_placement;
}

if ( ! empty( $flex_row ) ) {
	$css_classes[] = 'vc_row-flex';
}

$has_video_bg = ( ! empty( $video_bg ) && ! empty( $video_bg_url ) && vc_extract_youtube_id( $video_bg_url ) );

$parallax_speed = $parallax_speed_bg;
if ( $has_video_bg ) {
	$parallax = $video_bg_parallax;
	$parallax_image = $video_bg_url;
}
$parallax_content = '';
if ( ! empty( $parallax_image ) ) {
	if ( $has_video_bg ) {
		$parallax_image_src = $parallax_image;
	} else {
		$parallax_image_id = preg_replace( '/[^\d]/', '', $parallax_image );
		$parallax_image_src = wp_get_attachment_image_src( $parallax_image_id, 'large_bg' );
		if ( ! empty( $parallax_image_src[0] ) ) {
			$parallax_image_src = $parallax_image_src[0];
		}
	}
}

if(!$parallax) {
	$parallax_speed = 1;
}

$overlay_color_style = ('' != $overlay_color) ? 'background-color:'.$overlay_color.';' : '';
if($has_video_bg) {
	$parallax_content = '<div data-rokka-parallax="'.esc_attr( $parallax_speed ).'" style="background-image: url('.esc_url( $parallax_image_src ).')"  data-video="'.esc_attr( $video_bg_url ).'" data-video-start="'.esc_attr($video_start).'" class="extended_bg rokka-parallax rokka-video-bg-row"><div class="row-image-overlay" style="'.esc_attr($overlay_color_style).'"></div></div>';
} else {
	if(!empty($parallax_image)) {
		if(!$img_pattern) {
			if(!strpos($parallax_image, ',')) {
				$parallax_content = '<div data-rokka-parallax="'.esc_attr( $parallax_speed ).'" style="background-image: url('.esc_attr( $parallax_image_src ).')" class="extended_bg rokka-parallax"><div class="row-image-overlay" style="'.esc_attr($overlay_color_style).'"></div></div>';
			
			} else {
				$parallax_image = explode(',', $parallax_image);
				if(is_array($parallax_image)) {
					$slides = '';
					foreach ($parallax_image as $slider_image_id) {
						$slider_image_src = wp_get_attachment_image_src( $slider_image_id, 'large_bg' );
						if(!empty($slider_image_src[0] )) {
							$slider_image_src = $slider_image_src[0];
							$slides .= '<div data-slide="'.esc_url($slider_image_src).'"></div>';
						}
					}
					$parallax_content = '<div class="row-slides">'.$slides.'</div><div class="row-image-overlay" style="'.esc_attr($overlay_color_style).'"></div>'; 
				}
			}

		} else {
			$parallax_content = '<div style="background-image: url('.esc_attr( $parallax_image_src ).')" class="extended_bg pattern_bg"><div class="row-image-overlay" style="'.esc_attr($overlay_color_style).'"></div></div>';			
		}
	} else {
		if($overlay_color) {
			$parallax_content = '<div class="extended_bg"><div class="row-image-overlay" style="'.esc_attr($overlay_color_style).'"></div></div>';
		} else {
			$parallax_content = '<div class="extended_bg"><div class="row-image-overlay"></div></div>';
		}
	}
}

$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( array_unique( $css_classes ) ) ), $this->settings['base'], $atts ) );
if($text_color) {
	$text_color_style = 'style="color:'.$text_color.';"';
} else {
	$text_color_style = '';
}

$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '" '.$text_color_style.' data-overlay-color="'.esc_attr($overlay_color).'" data-color="'.esc_attr($text_color).'"  ';

$output .= '<div ' . implode( ' ', $wrapper_attributes ) . '>'.$parallax_content;
$output .= wpb_js_remove_wpautop( $content );
$output .= '</div>';
$output .= $after_output;
$output = '<div>'.$output.'</div>';

echo rokka_get_output($output);