<?php
/**
 * The template for displaying archive room.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/archive-room.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

get_header(); 
$colOffset = '';
if ( !is_active_sidebar( 'sidebar-room' ) ) {
	$colOffset = 'offset-lg-2';
}

?>

<div class="container">
	<div class="row">
		<div class="col-12 col-lg-8 <?php echo esc_attr($colOffset); ?>">
<?php
/**
 * hotel_booking_before_main_content hook
 */
do_action( 'hotel_booking_before_main_content' ); ?>

<?php
/**
 * hotel_booking_archive_description hook
 */
do_action( 'hotel_booking_archive_description' ); ?>

<?php if ( have_posts() ) : ?>

	<?php
	/**
	 * hotel_booking_before_room_loop hook
	 */
	do_action( 'hotel_booking_before_room_loop' ); ?>

	<?php hotel_booking_room_loop_start(); ?>

	<?php hotel_booking_room_subcategories(); ?>

	<?php while ( have_posts() ) : the_post(); ?>

		<?php hb_get_template_part( 'content', 'room' ); ?>

	<?php endwhile; ?>

	<?php hotel_booking_room_loop_end(); ?>

	<?php
	/**
	 * hotel_booking_after_room_loop hook
	 */
	do_action( 'hotel_booking_after_room_loop' ); ?>

<?php endif; ?>

<?php
/**
 * hotel_booking_after_main_content hook
 */
do_action( 'hotel_booking_after_main_content' ); ?>

</div>
<?php if(is_active_sidebar('sidebar-room')) : ?>
	<aside class="col-12 col-lg-4">
		<div class="room-sidebar">
			<?php dynamic_sidebar('sidebar-room'); ?>
		</div>
	</aside>
<?php endif; ?>
</div>
</div>
<?php get_footer(); ?>