<?php
/**
 * The template for displaying mini cart.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/cart/mini_cart.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

/**
 * @var $cart WPHB_Cart
 */
$cart  = WP_Hotel_Booking::instance()->cart;
$rooms = $cart->get_rooms();
?>

<?php if ( $rooms ) {
	foreach ( $rooms as $key => $room ) {
		if ( $cart_item = $cart->get_cart_item( $key ) ) {
			hb_get_template( 'loop/mini-cart-loop.php', array( 'cart_id' => $key, 'room' => $room ) );
		}
	} ?>

    <div class="hb_mini_cart_footer">

        <a href="<?php echo esc_url( hb_get_checkout_url() ); ?>"
           class="hb_checkout btn btn-dark btn-solid"><?php esc_html_e( 'Check Out', 'rokka' ); ?></a>
        <a href="<?php echo esc_url( hb_get_cart_url() ); ?>"
           class="hb_view_cart btn btn-accent btn-solid"><?php esc_html_e( 'View Cart', 'rokka' ); ?></a>

    </div>

<?php } ?>
