<?php
/**
 * The template for displaying existing customer form in checkout page.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/checkout/customer-existing.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

/**
 * @var $cart WPHB_Cart
 */
$cart = WP_Hotel_Booking::instance()->cart;
?>

<?php if ( ! is_user_logged_in() ) { ?>

	<div class="hb-order-existing-customer" data-label="<?php esc_attr_e( '-Or-', 'rokka' ); ?>">
		<div>
			<div class="text-center">
				<h4 class="heading-decorator-1 my-5"><?php esc_html_e( 'Existing customer?', 'rokka' ); ?></h4>
			</div>
			<div class="hb-form-table">
				<div class="hb-form-field">
					<label class="hb-form-field-label"><?php esc_html_e( 'Email', 'rokka' ); ?></label>
					<div class="hb-form-field-input">
						<input type="email" name="existing-customer-email"
							   value="<?php echo esc_attr( $cart->customer_email ); ?>"
							   placeholder="<?php esc_attr_e( 'Your email here', 'rokka' ); ?>"/>
					</div>
				</div>
				<div class="text-right">
					<button type="button" class="btn-accent btn btn-sm btn-solid" id="fetch-customer-info"><?php esc_html_e( 'Apply', 'rokka' ); ?></button>
				</div>
			</div>
		</div>
	</div>

<?php } ?>