<?php
/**
 * The template for displaying loop room title in archive room page.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/loop/title.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();
$args = array();
$terms = wp_get_post_terms( get_the_ID(), 'hb_room_type', $args);  
?>

<div class="title">
    <h2 class="h5">
        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
    </h2>

	<ul class="post-category">

	<?php 		
		if (is_array($terms)) {
			foreach ($terms as $c => $category) {
				echo '<li><a href="' . esc_url(get_category_link($category->term_id)) . '" title="' . esc_attr($category->name) . '">' . esc_html($category->name) . '</a></li>';
			}
		} 
	?>
    </ul>
</div>